/*
 * Decompiled with CFR 0.152.
 */
package satisfyu.beachparty.world.placers;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import org.jetbrains.annotations.NotNull;
import satisfyu.beachparty.registry.ObjectRegistry;
import satisfyu.beachparty.registry.PlacerTypesRegistry;

public class PalmFoliagePlacer
extends FoliagePlacer {
    public static final Codec<PalmFoliagePlacer> CODEC = RecordCodecBuilder.create(placer -> PalmFoliagePlacer.m_68573_((RecordCodecBuilder.Instance)placer).apply((Applicative)placer, PalmFoliagePlacer::new));

    public PalmFoliagePlacer(IntProvider pRadius, IntProvider pOffset) {
        super(pRadius, pOffset);
    }

    @NotNull
    protected FoliagePlacerType<?> m_5897_() {
        return (FoliagePlacerType)PlacerTypesRegistry.PALM_FOLIAGE_PLACER.get();
    }

    protected void m_213633_(LevelSimulatedReader pLevel, BiConsumer<BlockPos, BlockState> pBlockSetter, RandomSource pRandom, TreeConfiguration pConfig, int pMaxFreeTreeHeight, FoliagePlacer.FoliageAttachment pAttachment, int pFoliageHeight, int pFoliageRadius, int pOffset) {
        BlockPos startingPos = pAttachment.m_161451_();
        PalmFoliagePlacer.m_225622_((LevelSimulatedReader)pLevel, pBlockSetter, (RandomSource)pRandom, (TreeConfiguration)pConfig, (BlockPos)startingPos);
        PalmFoliagePlacer.createQuadrant(Direction.NORTH, startingPos, pLevel, pBlockSetter, pRandom, pConfig);
        PalmFoliagePlacer.createQuadrant(Direction.EAST, startingPos, pLevel, pBlockSetter, pRandom, pConfig);
        PalmFoliagePlacer.createQuadrant(Direction.SOUTH, startingPos, pLevel, pBlockSetter, pRandom, pConfig);
        PalmFoliagePlacer.createQuadrant(Direction.WEST, startingPos, pLevel, pBlockSetter, pRandom, pConfig);
    }

    public int m_214116_(RandomSource pRandom, int pHeight, TreeConfiguration pConfig) {
        return 0;
    }

    protected boolean m_214203_(RandomSource pRandom, int pLocalX, int pLocalY, int pLocalZ, int pRange, boolean pLarge) {
        return false;
    }

    private static void createQuadrant(Direction direction, BlockPos startingPos, LevelSimulatedReader pLevel, BiConsumer<BlockPos, BlockState> pBlockSetter, RandomSource pRandom, TreeConfiguration pConfig) {
        int i;
        BlockPos.MutableBlockPos pos = startingPos.m_122032_();
        pos.m_122173_(direction);
        PalmFoliagePlacer.m_225622_((LevelSimulatedReader)pLevel, pBlockSetter, (RandomSource)pRandom, (TreeConfiguration)pConfig, (BlockPos)pos);
        if (pRandom.m_188503_(2) == 0 && pLevel.m_7433_(pos.m_7495_(), BlockBehaviour.BlockStateBase::m_60795_)) {
            pBlockSetter.accept(pos.m_7495_(), ((Block)ObjectRegistry.COCONUT_HANGING.get()).m_49966_());
        }
        if (pRandom.m_188503_(2) == 0 && pLevel.m_7433_(pos.m_7495_().m_121945_(direction.m_122428_()), BlockBehaviour.BlockStateBase::m_60795_)) {
            pBlockSetter.accept(pos.m_7495_().m_121945_(direction.m_122428_()), ((Block)ObjectRegistry.COCONUT_HANGING.get()).m_49966_());
        }
        for (i = 0; i < 2; ++i) {
            pos.m_122173_(direction);
            PalmFoliagePlacer.m_225622_((LevelSimulatedReader)pLevel, pBlockSetter, (RandomSource)pRandom, (TreeConfiguration)pConfig, (BlockPos)pos);
            pos.m_122173_(Direction.DOWN);
            PalmFoliagePlacer.m_225622_((LevelSimulatedReader)pLevel, pBlockSetter, (RandomSource)pRandom, (TreeConfiguration)pConfig, (BlockPos)pos);
        }
        pos.m_122190_((Vec3i)startingPos);
        pos.m_122173_(direction).m_122173_(direction.m_122428_());
        PalmFoliagePlacer.m_225622_((LevelSimulatedReader)pLevel, pBlockSetter, (RandomSource)pRandom, (TreeConfiguration)pConfig, (BlockPos)pos);
        pos.m_122173_(Direction.DOWN).m_122173_(direction.m_122428_());
        PalmFoliagePlacer.m_225622_((LevelSimulatedReader)pLevel, pBlockSetter, (RandomSource)pRandom, (TreeConfiguration)pConfig, (BlockPos)pos);
        pos.m_122173_(direction);
        PalmFoliagePlacer.m_225622_((LevelSimulatedReader)pLevel, pBlockSetter, (RandomSource)pRandom, (TreeConfiguration)pConfig, (BlockPos)pos.m_121945_(direction.m_122427_()));
        for (i = 0; i < 3; ++i) {
            PalmFoliagePlacer.m_225622_((LevelSimulatedReader)pLevel, pBlockSetter, (RandomSource)pRandom, (TreeConfiguration)pConfig, (BlockPos)pos);
            pos.m_122173_(Direction.DOWN);
        }
    }
}

